# library
pacman::p_load(readxl, car, tidyverse)

# data
diet = read_excel("DataSets.xlsx",
                  sheet = 'z_t_test',
                  range = 'C31:E61')
head(diet)

# pivot_longer with before and after variable
diet_long = diet %>%
  pivot_longer(cols = c(before, after),
               names_to = "time",
               values_to = "weight")
head(diet_long)
diet_long$time = factor(diet_long$time,
              levels = c("before", "after"))
summary(diet_long$time)
leveneTest(weight ~ time, data = diet_long)
t.test(diet$before, diet$after, paired = TRUE)
